using System;

namespace InterfaceDemo
{
	interface IStorable
	{
		void Read();
		void Write(object obj);
		int Status { get; set; }
	}

	// Nowy interfejs 
	interface ICompressible
	{
		void Compress();
		void Decompress();
	}


	public class Document : IStorable, ICompressible
	{
		private int status = 0;

		public Document(string s)
		{
			Console.WriteLine("Tworzenie dokumentu: {0}", s);
		}

		#region IStorable

		public void Read()
		{
			Console.WriteLine(
			"Implementacja metody Read interfejsu IStorable");
		}

		public void Write(object o)
		{
			Console.WriteLine(
			"Implementacja metody Write interfejsu IStorable");
		}

		public int Status
		{
			get { return status; }
			set { status = value; }
		}

		#endregion // IStorable

		#region ICompressible

		public void Compress()
		{
			Console.WriteLine("Implementacja metody Compress");
		}
		public void Decompress()
		{
			Console.WriteLine("Implementacja metody Decompress");
		}

		#endregion // ICompressible
	}


	class Tester
	{
		public void Run()
		{
			Document doc = new Document("Dokument testowy");
			doc.Status = -1;
			doc.Read(); // Wywoanie metody interfejsu IStorable
			doc.Compress(); // Wywoanie metody interfejsu ICompressible
			Console.WriteLine("Status dokumentu: {0}", doc.Status);
		}

		static void Main()
		{
			Tester t = new Tester();
			t.Run();
		}
	}
}
